#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

using namespace std;

struct S {
    long long x, y;
    int id;
    double a;
};

bool cmp(const S& u, const S& v) {
    return u.a < v.a;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n;
    if (!(cin >> n)) return 0;

    vector<S> v;
    for (int i = 0; i < n; ++i) {
        long long x, y;
        cin >> x >> y;
        double a = atan2((double)y, (double)x);
        if (a < 0) a += 2 * M_PI;
        v.push_back({x, y, i + 1, a});
    }

    sort(v.begin(), v.end(), cmp);

    int m = v.size();
    for (int i = 0; i < m; ++i) {
        S t = v[i];
        t.a += 2 * M_PI;
        v.push_back(t);
    }

    long long cx = 0, cy = 0, mx = 0;
    int bl = 0, br = -1, l = 0;

    for (int r = 0; r < 2 * m; ++r) {
        cx += v[r].x;
        cy += v[r].y;

        while (v[r].a - v[l].a > M_PI + 1e-9) {
            cx -= v[l].x;
            cy -= v[l].y;
            l++;
        }

        long long d = cx * cx + cy * cy;
        if (d > mx) {
            mx = d;
            bl = l;
            br = r;
        }
    }

    if (br == -1) {
        cout << "0\n\n";
        return 0;
    }

    cout << (br - bl + 1) << "\n";
    for (int i = bl; i <= br; ++i) {
        cout << v[i].id << (i == br ? "" : " ");
    }
    cout << "\n";

    return 0;
}